/*---------------------------------------------------------------------------*\

    FILE....: VPBDIAL.H
    TYPE....: C++ Module Header File
    AUTHOR..: David Rowe
    DATE....: 13/2/98

	This file contains the implementation of the vpb_dial API function.
	
\*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

         Voicetronix Voice Processing Board (VPB) Software

         Copyright (C) 1999-2001 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
	 USA

\*---------------------------------------------------------------------------*/

#ifndef __VPBDIAL__
#define	__VPBDIAL__

void vpbdial_change_dtmf_length(int ontime_ms, int offtime_ms);
void vpbdial_open(USHORT numch);
void vpbdial_close();
void vpbdial_process_event(word mess[], USHORT board);
void vpbdial_validate(char *dialstr);
void vpbdial_dial_async(int chdev, char *dialstring);
void vpbdial_dial_sync(int chdev, char *dialstring);
void vpbdial_playtone(int handle, VPB_TONE *vpb_tone);
void vpbdial_check_arb();

#endif	// __VPBDIAL__

